<?php

class serv_Model_DbTable_Programa extends Zsam_Db_Table {

    /**
     * The default table name
     */
    protected $_name 		= 'progr';
    var $_autocomplet 		= array('CLIENTE','ITEM');
    //var $regime 			= null;

    var $_conf = array(
        'ID'				=> array("grid"=>true,'edit' => 'N'),
        'ITEM'	         		=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
	'EMPRESA'        		=> array("grid"=>true,'NULLABLE' => false,'edit' => 'N'),
    	'CLIENTE' 		 	=> array('autocomplete'=>'Y',"grid"=>true,'NULLABLE' => false,'edit' => 'N'),
        'CONTATO'         		=> array('NULLABLE' => false),
        'VENDEDOR'   			=> array('editlevel' => '3'),
        'DATA_ORCAMENTO'		=> array('edit' => 'N'),
	'FECHAR_ORCAMENTO'              => array(),
    	'DATA_PREV_ENTREGA'             => array(),	
    	'OBS_PREV_ENTREGA' 		=> array(),
    	'DATA_ENTREGA' 			=> array(),
    	'OBS_ENTREGA' 			=> array(),
        'VALOR_TOTAL'    		=> array('edit' => 'N'),
        'DATA_EXECUCAO_SERV'            => array('title' => 'DATANECESSIDADE','NULLABLE' => false),
        'NUMERO_NF'			=> array('edit' => 'N'),
        'DATA_NF'			=> array('edit' => 'N'),
	'VENCIMENTO'                    => array('title' => 'VENC','ORDER' => 'ID'),
        'VENCIMENTO_2'                  => array('ORDER' => 'ID'),
        'VENCIMENTO_3'                  => array('ORDER' => 'ID'),
    	'FORMA_PAGTO'			=> array("VP" => array("1"=>'apos_pagto',"2"=>'integral_antes_fat',"3"=>'primeira_parc_antes_fat')),
	'JUROS'                         => array(),
	'ULTIMO_ITEM'                   => array('edit' => 'N'),
	'TIPO'                          => array(),
        'TIPO_R_L'			=> array(),
	'TIPO_FRETE'                    => array('VP' => 'FOB,CIF,EXW', 'NULLABLE' => false),
	'VALOR_FRETE'                   => array(),
	'VALOR_SEGURO'                  => array(),
        'PRAZO_ENTREGA_DIAS'            => array('NULLABLE' => false),
        'OBSERVACAO'			=> array(),
        'REFERENCIA_CLIENTE'            => array("grid"=>true),
        'REFERENCIA_PEDIDO'		=> array(),
	'BAIXA'          		=> array(),
	'DEPARTAMENTO' 			=> array(),
	'STATUS' 			=> array(),
	'STATUS_PADRAO'			=> array(),
	'SITUACAO'        		=> array('title' => 'tem_estoque_S_sim_N_nao_K_falta_num_serie'),
        'APROVACAO'			=> array('edit' => 'N'),
    	'GRID' 				=> array('type' 	=> 'itemGrid',
	    	        					 'model' 		=> 'serv_Model_DbTable_Programaitem',
	    	        					 'controller'           => 'serv_ProgramaitemController',
	    	        					 'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','PRODUTO','QUANTIDADE',
	    	        					         				 'PRECO_UNITARIO','CFOP','PRECO_TOTAL_ITEM'),

	    	        					 'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
	            						 'buttons'		=> array('edit'=>'S')),
		'GRID1'         	=> array(),
        'FUNC_ALTERACAO' 		=> array('edit' => 'N'),
        'DATA_ALTERACAO' 		=> array('edit' => 'N'),
        'REVISAO'        		=> array('edit' => 'N'),
        'DATASINC'       		=> array('edit' => 'N'),
	);
    var $_referenceMap = array(
        'EMPRESA' => array(
            'columns'       => 'EMPRESA',
            'refTableClass' => 'core_Model_DbTable_Empresa',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'NOME'
        ),
        'CLIENTE' => array(
            'columns'       => 'CLIENTE',
            'refTableClass' => 'serv_Model_DbTable_Cliente',
            'refColumns'    => 'CODIGO',
            'refTitle'      => 'CLIENTE'
        ),

	'VENDEDOR' => array(
            'columns'           => 'VENDEDOR',
            'refTableClass'     => 'core_Model_DbTable_Usuario',
            'refColumns'        => 'ID',
            'refTitle'          => 'VENDEDOR'
    	),

    	'VENCIMENTO' => array(
            'columns'           => 'VENCIMENTO',
            'refTableClass'     => 'core_Model_DbTable_Vencimento',
            'refColumns'        => 'ID',
            'refTitle'          => 'DESCRICAO'
    	),

    	'CONTATO' => array(
            'columns'           => 'CONTATO',
            'refTableClass'     => 'core_Model_DbTable_Clientecontatoitem',
            'refColumns'        => 'ID',
            'refTitle'          => 'CONTATO',
    	    'semChave'		=> 'S'    //neste caso  quando temos uma chave primaria composta e incluimos o ID para poder fazer orelacionamento
										//porem o ID no  chave primaria e portanto no zsam form simple (linha +-103) desabilitamos o validador do zend para chave primaria
		),

    	'DEPARTAMENTO' => array(
    		'columns'           => 'DEPARTAMENTO',
    		'refTableClass'     => 'core_Model_DbTable_Depto',
    		'refColumns'        => 'DEPARTAMENTO',
    		'refTitle'          => 'DEPARTAMENTO'
    	),

    	'STATUS_PADRAO' => array(
    		'columns'           => 'STATUS_PADRAO',
    		'refTableClass'     => 'core_Model_DbTable_Obsprogr',
    		'refColumns'        => 'CODIGO',
    		'refTitle'          => 'STATUS_PADRAO'
    	),

    	'GRID' => array(
    		'columns'           => 'GRID',
    		'refTableClass'     => 'serv_Model_DbTable_Programaitem',
    		'refColumns'        => 'ITEM_PROGR',
    		'refTitle'          => 'ITEM'
    	)

    );

    public function __construct(){
        $this->config  = Zend_Registry::get('Cisweb_Config');

        $controller      = Zend_Controller_Front::getInstance()->getRequest();
        $nome_controller = $controller->getControllerName(); //pegar a controladora
        $nome_action 	 = $controller->getActionName(); //pegar a controladora
        $nome_modulo     = $controller->getModuleName();
        $cliente         = Zend_Registry::get('Cliente');

        //trecho adicionado de forma provisria (desenvolvimento de processos para programa)
        if ($nome_modulo == 'especial' && $nome_controller == 'programa') {
            //$this->_conf['GRID']['controller'] = 'especial_ProgramaitemController';
            
            
            /*$this->_conf['GRID']    = array('type' 		=> 'itemGrid',
        			'model' 		=> 'especial_Model_DbTable_Programa',
        			'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','VEICULO','QUANTIDADE',
                                                        'PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
        			'restrict'		=> "COMPRA_OU_VENDA = '1'",
        			'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
        			'buttons'		=> array('edit'=>'S'));*/
            
            
            $this->_conf['GRID']  			= array('type' 	=> 'itemGridAuto', //Padrão, indica o helper que monta a grid
                                                        'configitem' 	=> 'GRID', //Indica qual campo do atributo $zsam_form_item da controladora deve ser usado			  
                                                        'model' 	=> 'serv_Model_DbTable_Programaitem', //Model do filho
                                                        //Colunas que aparecerão na grid
                                                        'columns' 	=> array('NUM_ITEM','PRODUTO','QUANTIDADE','PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
                                                        'idWhere' 	=> array('CLIENTE','ITEM_PROGR'),//Chave primária sem o campo "auto increment"
                                                        'buttons'	=> array('edit'=>'S', 'del' => 'S'));//Configuração dos botões da grid

            
            
            if($cliente[0]['CODIGO'] != "s28431"){
                $this->_conf['VENCIMENTO_2']['level'] = 5;
                $this->_conf['VENCIMENTO_3']['level'] = 5;  
            }else{
                 $this->_referenceMap['VENCIMENTO_2'] =  array(   
            
                    'columns'           => 'VENCIMENTO_2',
                    'refTableClass'     => 'core_Model_DbTable_Vencimento',
                    'refColumns'        => 'ID',
                    'refTitle'          => 'VENCIMENTO_2'
                );
            
                $this->_referenceMap['VENCIMENTO_3'] =  array(   
            
                    'columns'           => 'VENCIMENTO_3',
                    'refTableClass'     => 'core_Model_DbTable_Vencimento',
                    'refColumns'        => 'ID',
                    'refTitle'          => 'VENCIMENTO_3'
                );
            }
        }

        $auth = Zend_Auth::getInstance();
            if ($auth->hasIdentity()) {
                    $user = $auth->getStorage()->read();
                    $funcao = @$user['FUNCAO'];
                    $id     = @$user['ID'];
                    $nome   = @$user['NOME'];
                    $level  = @$user['NIVEL'];
            }

        if ($level < 3 && $this->config[0]['VENDEDOR_POR_CLIENTE_RESTRICT'] != 'N') {
            $this->_restrict = "(FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O') AND VENDEDOR = " .$id;
        } else {
            $this->_restrict = "FECHAR_ORCAMENTO  != 'S' OR FECHAR_ORCAMENTO IS NULL AND TIPO = 'O'";
        }

        if ($nome_controller == 'programa') {
            $this->_conf['DEPARTAMENTO']['NULLABLE'] = false;
            
            if ($nome_action == 'upd') {
                $table  = new Cisweb_Db_Abstract("progr");
                $venc 	= new Cisweb_Db_Abstract("venc");

                $id 	= $controller->getParam("id");
                $id 	= explode(":", $id);
                $id1 	= $id[0];
                $id2 	= $id[1];
                $dados 	= $table->getAdapter()->fetchRow($table->select()->where("CLIENTE = '$id1' AND ITEM = '$id2'"));
     
                if ($dados['VENCIMENTO'] != '') {
                    $this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S' or ID = '{$dados['VENCIMENTO']}'";
                } else {
                    $this->_conf['VENCIMENTO']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S'";
                }
                
                $this->ConfiguraCliente($cliente[0]['CODIGO'],$dados);
            }
        }

        if ($nome_controller == 'programanfe') {
            $this->_conf['ITEM']['edit'] = 'S';
            $this->_conf['EMPRESA']['edit'] = 'S';
            $this->_conf['CLIENTE']['edit'] = 'S';
        }

        if($nome_controller == 'programaveiculo')
        {
        	
        	if ($nome_action == 'upd'){
        	
                    $idprog = $controller->getParam('id');
                    $idprog = explode(':', $idprog);

                    //$this->calcula_total($idprog);
        		
        	}	

        	$this->_referenceMap['GRID'] =  array(
    		'columns' 		=> 'ITEM_PROGR',
    		'refTableClass' => 'especial_Model_DbTable_Programaveiculoitem',
    		'refColumns' 	=> 'ITEM_PROGR',
    		'refTitle' 		=> 'ITEM'
    		);
        	
        	$this->_referenceMap['GRID1'] =  array(
        			'columns' 		=> 'ITEM_PROGR',
        			'refTableClass' => 'especial_Model_DbTable_Programaveiculoitem',
        			'refColumns' 	=> 'ITEM_PROGR',
        			'refTitle' 		=> 'ITEM'
        	);


        	$this->_conf['GRID']    = array('type' 		=> 'itemGrid',
        			'model' 		=> 'especial_Model_DbTable_Programaveiculoitem',
        			'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','VEICULO','QUANTIDADE',
        					'PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
        			'restrict'		=> "COMPRA_OU_VENDA = '1'",
        			'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
        			'buttons'		=> array('edit'=>'S'));
        	
        	$this->_conf['GRID1']    = array('type' 	=> 'itemGrid',
        			'model' 		=> 'especial_Model_DbTable_Programaveiculoitem',
        			'controller' 	=> 'Programacompraveicitem',
        			'columns' 		=> array('CLIENTE','ITEM_PROGR','NUM_ITEM','MODELO','QUANTIDADE','ANO_MODELO',
        					'PRECO_UNITARIO','PRECO_TOTAL_ITEM'),
        			'restrict'		=> "COMPRA_OU_VENDA = '-1'",
        			'idWhere' 		=> array('CLIENTE','ITEM_PROGR'),
        			'buttons'		=> array('edit'=>'N','edit2'=>'S','insert'=>'N','insert2'=>'S','rem' =>'N','rem2'=>'S'));
        }

        if($nome_controller == 'impressaoormcliente')
        {
            $this->_restrict = "TIPO = 'O' AND FECHAR_ORCAMENTO = 'S' ";
            $this->_conf['DATA_ORCAMENTO']['grid'] = true;
        }
        
        if($nome_controller == 'programaentrega')
        {
        	$this->_restrict = "TIPO = 'P' AND  DATA_PEDIDO > '2013-11-01' AND DATA_ENTREGA IS NULL";
        	//$this->_conf['DATA_ORCAMENTO']['grid'] = true;
        	
        	$this->_conf['VENDEDOR']['edit'] 			= 'N';
        	$this->_conf['CONTATO']['edit'] 			= 'N';
        	$this->_conf['DEPARTAMENTO']['edit'] 		= 'N';
        	$this->_conf['DATA_PREV_ENTREGA']['edit'] 	= 'S';
        	$this->_conf['OBS_PREV_ENTREGA']['edit'] 	= 'S';
        	$this->_conf['VALOR_FRETE']['edit'] 		= 'N';
        	$this->_conf['VALOR_SEGURO']['edit'] 		= 'N';
        	$this->_conf['TIPO_FRETE']['edit'] 			= 'N';
        	$this->_conf['REFERENCIA_CLIENTE']['edit'] 	= 'N';
        	$this->_conf['OBSERVACAO']['edit'] 			= 'N';
        	$this->_conf['PRAZO_ENTREGA_DIAS']['edit'] 	= 'N';
        	$this->_conf['PRAZO_ENTREGA_DIAS']['NULLABLE'] = true;
        	$this->_conf['DATA_EXECUCAO_SERV']['edit'] 	= 'N';
        	$this->_conf['DATA_EXECUCAO_SERV']['NULLABLE'] = true;
        	$this->_conf['DATA_PEDIDO']['edit'] 		= 'N';
        	$this->_conf['STATUS']['edit'] 				= 'S';
        	$this->_conf['CONTATO']['NULLABLE'] 		= true;
        	$this->_conf['NUMERO_NF']['grid'] 			= true;
        	$this->_conf['DATA_NF']['grid'] 			= true;
        	$this->_conf['DATA_ENTREGA']['validate'] 	= 'Cisweb_Validate_Dataentregaestoque';
            $this->_conf['GRID']['buttons'] = array('insert'=>'N','edit'=>'N','rem'=>'N');   	
        }

        if($nome_controller == 'impressaopedidocliente')
        {
        	$this->_restrict = "TIPO = 'P'";
        	$this->_conf['DATA_ORCAMENTO']['grid'] 		= true;
        	$this->_conf['REFERENCIA_CLIENTE']['grid'] 	= false;
        	$this->_conf['REFERENCIA_PEDIDO']['grid'] 	= true;
        	$this->_conf['NUMERO_NF']['grid'] 			= true;
        	$this->_conf['DATA_NF']['grid'] 			= true;
        }

        if($nome_controller == 'reprovaitem')
        {
            $this->_restrict = "TIPO = 'O'";
        }

        if($nome_controller == 'pedidosparafaturar')
        {
            $this->_restrict = "(SITUACAO = 'S' OR SITUACAO = 'K')  AND TIPO = 'P' AND (BAIXA <> 'B' OR BAIXA IS NULL)";
            $this->_conf['VALOR_TOTAL']['grid'] 		= TRUE;
            $this->_conf['REFERENCIA_CLIENTE']['grid']	= FALSE;
            $this->_conf['STATUS']['grid'] 				= TRUE;
            $this->_conf['STATUS_PADRAO']['grid'] 		= TRUE;
        }

        if($nome_controller == 'pedidosparafaturarsemestoque')
        {
            $this->_restrict = "SITUACAO = 'N' AND TIPO = 'P'";
            $this->_conf['VALOR_TOTAL']['grid'] 		= TRUE;
            $this->_conf['REFERENCIA_CLIENTE']['grid']	= FALSE;
            $this->_conf['STATUS']['grid'] 				= TRUE;
            $this->_conf['STATUS_PADRAO']['grid'] 		= TRUE;
        }

        parent::__construct();
    }
    
    
    
    private function ConfiguraCliente($cliente,$dados) {
        
        if($cliente == "s28431"){
        
            if ($dados['VENCIMENTO_2'] != '') {
                      $this->_conf['VENCIMENTO_2']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S' or ID = '{$dados['VENCIMENTO_2']}'";
            } else {
                      $this->_conf['VENCIMENTO_2']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S'";
            }

            if ($dados['VENCIMENTO_3'] != '') {
                $this->_conf['VENCIMENTO_3']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S' or ID = '{$dados['VENCIMENTO']}'";
            } else {
                $this->_conf['VENCIMENTO_3']['RESTRICT_MAP'] = "LIBERADO_PARA_USO = 'S'";
            }
        }
    } 
    
    
    public function calcula_total($id)
    {
    
    	$table 		= new especial_Model_DbTable_Programaveiculoitem();
    	$table2 	= new serv_Model_DbTable_Programa();
    	$cli 		= $id[0];
    	$item 		= $id[1];
    	
    	$dados_item = $table->getAdapter()->fetchAll($table->select()->where("CLIENTE = '$cli' AND ITEM_PROGR = '$item'"));
    	 
      	$total = 0;
    
    	foreach ($dados_item as $key => $value)
    	{
    		$total 		+= $value['PRECO_TOTAL_ITEM'];
    	}
    
    	$data['VALOR_TOTAL'] = $total;
    	
    	$where = "CLIENTE = '$cli' AND ITEM = '$item'";
    	
    	$table2->update($data,$where);
    }


  	public function beforeInsert(array $data) {
        if (is_null($data['TIPO']) || $data['TIPO'] == ''){
			$data['TIPO'] = 'O';
		}
        return parent::beforeInsert($data);
    }

    
    public function beforeValidade($form, $dados)
    {
    	 
    	$controller 		= Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller 	= $controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
    	 
    	if ($nome_controller == 'programa')
    	
    	if ($dados['FORMA_PAGTO'] == '2' || $dados['FORMA_PAGTO'] == '3')
    	{
    		$form->getElement("VENCIMENTO")->setRequired(true);
    	}
    }

    public function beforeUpdate($data, $where) {

    	$controller      = Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller = $controller->getControllerName(); //pegar a controladora

    	if ($nome_controller == 'programa') {
            if (isset($data['TIPO'])) {
                if ($data['TIPO'] <> 'P')
                    $data['TIPO'] = 'O';
            } else
                $data['TIPO'] = 'O';

            $table_itens = new serv_Model_DbTable_Programaitem();
            $cliente = $where[' CLIENTE = ? '];
            $item = $where[' ITEM = ? '];


            $dados_orm_cliente = $this->find($cliente, $item)->toArray();

            if ((@$dados_orm_cliente[0]['VENCIMENTO '] != @$data['VENCIMENTO'])) {

                //recalcular o total baseado na nova condio de pagamento
                $model_programa = new serv_Model_Programa();
                $total = $model_programa->CalculaTotal($dados_orm_cliente[0],$data['VENCIMENTO'],'ID');
                $data['VALOR_TOTAL'] = $total;
            }

            $dados_itens = $table_itens->getAdapter()->fetchAll($table_itens->select()->where("CLIENTE = '$cliente' AND ITEM_PROGR = '$item'"));

            if (!is_null(@$data['VALOR_FRETE']) || !is_null(@$data['VALOR_SEGURO'])) {
                if (count($dados_itens) != 0)
                    ; {
                    $this->rateiofrete_seguro($data, $dados_itens); // calcula rateio do frete....
                }
            }
            //die('uashaushau');
        }

        return parent::beforeUpdate($data, $where);

    }

    public function beforeDelete($where)
    {
    	/*
    	 * INSERIDO POR TIAGO - ROLLBACK DA PETRONECT
    	 */
    	$table 		= new Cisweb_Db_Abstract('cotacaoforne');
    	$cli 		= $where[' CLIENTE = ? '];
    	$num 		= $where[' ITEM = ? '];
    	$datacot['NUM_PEDIDO_VENDA'] = NULL;
    	$wherecot 	= "CLIENTE = '$cli' AND NUM_PEDIDO_VENDA = '$num'";
    	$table->update($datacot, $wherecot);

    	return parent::beforeDelete($where);
    }


    public function rateiofrete_seguro( $data , $dados_itens)
    {
    	$table_itens 			= new Cisweb_Db_Abstract('progritens');

    	$valor_frete_total 		= 0;
    	$valor_seguro_total 	= 0;

    	$frete 					= $data['VALOR_FRETE'];
    	$seguro 				= $data['VALOR_SEGURO'];
    	$total 					= $data['VALOR_TOTAL'];

    	foreach ($dados_itens as $key => $value) {
            $valor_frete = 0;
            $valor_seguro = 0;

            $dataitens = array();

            if ($frete != '') {

                $valor_frete = ($frete / $total) * $value['PRECO_TOTAL_ITEM'];
                $valor_frete_total += $valor_frete;
                $dif = ($frete - $valor_frete_total);
                if ($dif < 0)
                    $dif1 = ($dif * (-1));
                else
                    $dif1 = $dif;
                if ($dif1 <= 0.05)
                    $valor_frete = ($valor_frete + $dif);

                $valor_frete = number_format($valor_frete, 2, '.', '');
            }


            if ($seguro != '') {

                $valor_seguro = ($seguro / $total) * $value['PRECO_TOTAL_ITEM'];
                $valor_seguro_total += $valor_seguro;
                $dif = ($seguro - $valor_seguro_total);
                if ($dif < 0)
                    $dif1 = ($dif * (-1));
                else
                    $dif1 = $dif;
                if ($dif1 <= 0.05)
                    $valor_seguro = ($valor_seguro + $dif);

                $valor_seguro = number_format($valor_seguro, 2, '.', '');
            }

            if ($value['STICMS'] == '00') {

                $dataitens['VALOR_FRETE'] = $valor_frete;
                $dataitens['VALOR_SEGURO'] = $valor_seguro;

                $dataitens['BASE_DE_CALCULO_ICMS'] = $value['PRECO_TOTAL_ITEM'] + ($valor_frete + $valor_seguro);
                $dataitens['BASE_DE_CALCULO_IPI'] = $value['PRECO_TOTAL_ITEM'] + ($valor_frete + $valor_seguro);
                $dataitens['BASE_DE_CALCULO_PIS'] = $value['PRECO_TOTAL_ITEM'] + ($valor_frete + $valor_seguro);
                $dataitens['BASE_DE_CALCULO_COFINS'] = $value['PRECO_TOTAL_ITEM'] + ($valor_frete + $valor_seguro);

                $iditem = $value['ID'];
                $whereitens = "ID = '$iditem'";

                $table_itens->update($dataitens, $whereitens);
            }
        }
    }


   public function deleteCascade($id,$emp){

    	$controller = Zend_Controller_Front::getInstance()->getRequest();
    	$nome_controller=$controller->getControllerName(); // PEGA O NOME DA CONTROLADORA
    	$table 		= new serv_Model_DbTable_Programaitem();
    	$adapter 	= $table->getAdapter();
    	$where 		= $adapter->quoteInto('CLIENTE = ?', $id).' AND '.$adapter->quoteInto(' ITEM_PROGR = ?', $emp);
    	$table->delete($where);
   }


   // pegar impostos do NCM E ICMS....
   public function getImposto($item, $cliente, $itemprog) {

        $table_estado = new core_Model_DbTable_Estado();
        $table_ncm = new core_Model_DbTable_Ncm();
        $table_empresa = new core_Model_DbTable_Empresa();
        $table_ativos = new core_Model_DbTable_Ativoprodutos();
        $table_cidade = new core_Model_DbTable_Cidade();
        $table_fornecedor = new serv_Model_DbTable_Fornecedor();
        $table_ncmst = new core_Model_DbTable_Ncmst();
        $table_cliente = new serv_Model_DbTable_Cliente();
        $table_progitem = new serv_Model_DbTable_Programaitem();


        $where = "CLIENTE = '$cliente' AND ITEM = '$item'";
        $campos = $this->getAdapter()->fetchRow($this->select()->where(($where)));

        //Dados da empresa
        $camposemp = $table_empresa->find($campos['EMPRESA'])->current();
        $camposcityemp = $table_cidade->find($camposemp['CIDADE'])->current();
        $camposestadoempresa = $table_estado->find($camposcityemp['UF'])->current();

        //Dados do cliente
        $camposcli = $table_cliente->find($campos['CLIENTE'])->current();
        $camposcitycli = $table_cidade->find($camposcli['CIDADE'])->current();
        $camposestadocliente = $table_estado->find($camposcitycli['UF'])->current();

        $aliquota_icms = $camposestadoempresa["ICMS_{$camposestadocliente['UF']}"];

        $aliquota_icms_st = $camposestadoempresa["ICMS_{$camposestadoempresa['UF']}"];
        $arr['ALIQUOTA_ICMS_ST'] = $aliquota_icms_st;

        // verifica se ja existe o imposto cadastrado........
        $where2 = "CLIENTE = '$cliente' AND ITEM_PROGR = '$item' AND NUM_ITEM = '$itemprog'";
        $campos2 = $table_progitem->getAdapter()->fetchRow($table_progitem->select()->where(($where2)));

        $arr['REGIME_TRIBUTARIO'] = $camposemp['REGIME_TRIBUTARIO'];

        if ($camposemp['REGIME_TRIBUTARIO'] <= 2 || $camposemp['REGIME_TRIBUTARIO'] == 11 || $camposemp['REGIME_TRIBUTARIO'] == 12) {
            if (!empty($campos2['CFOP'])) {
                $arr['ALIQUOTA_ICMS'] = $campos2['ALIQUOTA_ICMS'];
                $arr['BASE_DE_CALCULO_ICMS'] = $campos2['BASE_DE_CALCULO_ICMS'];
                $arr['TOTAL_ICMS'] = $campos2['TOTAL_ICMS'];
            } else {
                $arr['ALIQUOTA_ICMS'] = '0.00';
            }
        } else {
            //if (!isset($campos2['ALIQUOTA_ICMS'])) 	$arr['ALIQUOTA_ICMS']   = $aliquota_icms;
            //else  $arr['ALIQUOTA_ICMS']    = $campos2['ALIQUOTA_ICMS'];

            $arr['ALIQUOTA_ICMS'] = $aliquota_icms;
        }

        $arr['ORIGEM'] = $campos2['ORIGEM_SIT_TRIBUTARIA'];

        $ipi = $this->getIPI($campos2['NCM']);

        if ($ipi)
            $arr['IPI'] = $ipi;
        else
            $arr['IPI'] = "";

        return $arr;
    }

    public function getAliq_origem($cliente = null, $empresa, $forne = null) {

        $table_empresa = new Cisweb_Db_Abstract("empresa");

        if (!is_null($cliente)) {
            $table_cliente = new Cisweb_Db_Abstract("cliente");
        } else {
            $table_cliente = new Cisweb_Db_Abstract("forne");
        }

        $table_estado = new Cisweb_Db_Abstract("estados");
        $table_cidade = new Cisweb_Db_Abstract("cidades");
        $table_pais = new Cisweb_Db_Abstract("paises");
        $table_cfop = new Cisweb_Db_Abstract("cfop");

        //Dados da empresa
        $camposemp = $table_empresa->find($empresa)->current();
        $camposcityemp = $table_cidade->find($camposemp['CIDADE'])->current();
        $camposestadoempresa = $table_estado->find($camposcityemp['UF'])->current();
        $campospaisempresa = $table_pais->find($camposestadoempresa['PAIS'])->current();

        //Dados do cliente
        if (!is_null($cliente)) {
            $camposcli = $table_cliente->find($cliente)->current();
        } else {
            $camposcli = $table_cliente->find($forne)->current();
        }
        $camposcitycli = $table_cidade->find($camposcli['CIDADE'])->current();
        $camposestadocliente = $table_estado->find($camposcitycli['UF'])->current();
        $campospaiscliente = $table_pais->find($camposestadocliente['PAIS'])->current();

        $arr = array();
        if ($camposemp['REGIME_TRIBUTARIO'] == 3 || $camposemp['REGIME_TRIBUTARIO'] == 4 || $camposemp['REGIME_TRIBUTARIO'] == 13 || $camposemp['REGIME_TRIBUTARIO'] == 14) {
            if ($camposcityemp['UF'] != $camposcitycli['UF']) {
                $arr['ALIQ_ORIGEM'] = '4';
            }
        }

        return $arr;
    }

    public function getProduto($produto,$cliente = null, $empresa = null )
   {

       $table						 = new Cisweb_Db_Abstract("produtos");
       $campos						 = $table->find($produto)->current();
       $arr['ORIGEM_SIT_TRIBUTARIA'] = $campos['ORIGEM_SIT_TRIBUTARIA'];
       $arr['NCM'] 					 = $campos['CLASFISCAL'];
       $arr['UNI'] 					 = $campos['UNIDADE'];
       $arr['FAB'] 					 = '';

       if (! is_null($campos['FABRICANTE']))
       $arr['FAB'] 					 .= 'Fabr:'.$campos['FABRICANTE'].';';

       if (! is_null($campos['FABRICANTE_CODIGO']))
       $arr['FAB'] 					 .= 'Cod Fabr:'.$campos['FABRICANTE_CODIGO'].';';

       if ($campos['ORIGEM_SIT_TRIBUTARIA'] == 1  || $campos['ORIGEM_SIT_TRIBUTARIA'] == 2 || $campos['ORIGEM_SIT_TRIBUTARIA'] == 3)
       {
			$retorno = $this->getAliq_origem($cliente, $empresa);
			if (isset($retorno['ALIQ_ORIGEM']))
			{
				$arr['ALIQ_ORIGEM'] = $retorno['ALIQ_ORIGEM'];
			}
       }

       return $arr;
   }

   public function getBaseReduzida($produto,$cfop,$ncm,$st)
   {

   	$table						 		= new Cisweb_Db_Abstract("cfop");
   	$table_ncm						 	= new Cisweb_Db_Abstract("ncm");

   	$campos						 		= $table->find($cfop)->current();
   	$campos_ncm						 	= $table_ncm->find($ncm)->current();

   	$arr = array();

   	if (strlen($st) == 2 && $campos['STICMS_BR'] != '' && $campos_ncm['ICMS_BR'] != '')
   	{

   		$arr['STICMS_BR'] = $campos['STICMS_BR'];

   		if ($campos_ncm['ALIQUOTA_ICMS_BR'] != '')
   		{
   			$arr['ALIQUOTA_ICMS_BR'] = $campos_ncm['ALIQUOTA_ICMS_BR'];
   		}
   	}



   	return $arr;

   }

   public function getPrecobase($produto,$empresa)
   {

   	$table						 = new Cisweb_Db_Abstract("produtos");
   	$table2						 = new Cisweb_Db_Abstract("empresa");
   	$campos						 = $table->find($produto)->current();
   	$campos2					 = $table2->find($empresa)->current();

   	$arr['PRECO_BASE'] = null;
   	$preco = 0;

    $datavalidade = date('Y-m-d',mktime(0, 0, 0,date('m'),date('d')-$campos2['DIAS_VALIDADE_PRECO'],date('Y')));
    $arr['DATA_VALIDADE'] = $datavalidade;

   	if (!empty($campos['DATA_ULTIMA_COMPRA']) && !empty($campos['DATA_ORCAMENTO'])){

   		if ($campos['DATA_ULTIMA_COMPRA'] >= $campos['DATA_ORCAMENTO']){

   			if ($campos['DATA_ULTIMA_COMPRA'] >= $datavalidade){

				if(isset($campos2['MARGEM_GERAL_BASE'])){

					$preco = $campos['PRECO_ULTIMA_COMPRA'] * $campos2['MARGEM_GERAL_BASE'];
					$arr['PRECO_BASE'] = $preco;
				}
			}
   		}
   		else{

   			if ($campos['DATA_ORCAMENTO'] >= $datavalidade){

				if(isset($campos2['MARGEM_GERAL_BASE'])){

					$preco = $campos['PRECO_ORCAMENTO'] *$campos2['MARGEM_GERAL_BASE'];
					$arr['PRECO_BASE'] = $preco;
				}
			}
   		}
   	}
   	elseif(!empty($campos['DATA_ULTIMA_COMPRA'])){

		if ($campos['DATA_ULTIMA_COMPRA'] >= $datavalidade){

			if(isset($campos2['MARGEM_GERAL_BASE'])){

				$preco = $campos['PRECO_ULTIMA_COMPRA'] * $campos2['MARGEM_GERAL_BASE'];
				$arr['PRECO_BASE'] = $preco;
			}
		}
   	}
   	elseif(!empty($campos['DATA_ORCAMENTO'])){

		if ($campos['DATA_ORCAMENTO'] >= $datavalidade){

			if(isset($campos2['MARGEM_GERAL_BASE'])){

				$preco = $campos['PRECO_ORCAMENTO'] *$campos2['MARGEM_GERAL_BASE'];
				$arr['PRECO_BASE'] = $preco;
			}
		}
   	}

   	return $arr;
   }

   public function getCfop($cli,$emp)
   {


   	$table_empresa			= new Cisweb_Db_Abstract("empresa");
   	$table_cliente			= new Cisweb_Db_Abstract("cliente");
   	$table_estado			= new Cisweb_Db_Abstract("estados");
   	$table_cidade			= new Cisweb_Db_Abstract("cidades");
   	$table_pais				= new Cisweb_Db_Abstract("paises");
   	$table_cfop				= new Cisweb_Db_Abstract("cfop");

   	//Dados da empresa
   	$camposemp 				= $table_empresa->find($emp)->current();
   	$camposcityemp 			= $table_cidade->find($camposemp['CIDADE'])->current();
   	$camposestadoempresa	= $table_estado->find($camposcityemp['UF'])->current();
   	$campospaisempresa		= $table_pais->find($camposestadoempresa['PAIS'])->current();

   	//Dados do cliente
   	$camposcli 				= $table_cliente->find($cli)->current();
   	$camposcitycli 			= $table_cidade->find($camposcli['CIDADE'])->current();
   	$camposestadocliente	= $table_estado->find($camposcitycli['UF'])->current();
   	$campospaiscliente		= $table_pais->find($camposestadocliente['PAIS'])->current();


   	if ($camposestadoempresa['PAIS'] != $camposestadocliente['PAIS'])
   	{
   		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 6999 AND CODIGO < 8000) AND (TIPONF = 'F' OR TIPONF = 'A')"));

   	}
   	elseif($camposcityemp['UF'] != $camposcitycli['UF'])
   	{
   		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 5999 AND CODIGO < 7000) AND (TIPONF = 'F' OR TIPONF = 'A')"));

   	}
   	else
   	{
   		$camposcfop = $table_cfop->getAdapter()->fetchAll($table_cfop->select()->where("(CODIGO > 4999 AND CODIGO < 6000) AND (TIPONF = 'F' OR TIPONF = 'A')"));

   	}

   	return $camposcfop;
   }


   public function getCfopedit($cli,$emp,$prog,$item)
   {

   	$controller      = Zend_Controller_Front::getInstance()->getRequest();
   	$nome_controller = $controller->getControllerName(); //pegar a controladora
   	
   	$where_prog			= "CLIENTE = '$cli' AND EMPRESA = '$emp' AND ITEM_PROGR = '$prog' AND NUM_ITEM = '$item'";
   	
   	if ($nome_controller == 'programaveiculoitem')
   	{
   		$table_prog  		= new especial_Model_DbTable_Programaveiculoitem();
   	}	
   	else
   		$table_prog  		= new serv_Model_DbTable_Programaitem();
   	
   	$rowset_prog 		= $table_prog->getAdapter()->fetchAll($table_prog->select()->where(($where_prog)));

   	$cont  = count($rowset_prog);

   	if ($cont > 0)
   	{

   		$cfop_original['CFOP'] 						= $rowset_prog[0]['CFOP'];

   	}
   	else
   	{
   		$cfop_original 								= array();
   	}

   	return $cfop_original;
   }

   public function getNcm($ncm)
   {
   	$table				= new Cisweb_Db_Abstract("ncm");
   	return $campos 			= $table->find($ncm)->current()->toArray();

   }


   public function getIPI($ncm)
   {
	   	if ($ncm == '')
	   	{
	   		return false;
	   	}
	
	   	$table = new core_Model_DbTable_Ncm();
	   	$dados = $table->find($ncm);
	
	   	if (isset($dados[0]['IPI']))
	   	{
	   		if ($dados[0]['IPI'] != '')
	   		{
	   			return $dados[0]['IPI'];
	   		}
	   		else
	   		{
	   			return false;
	   		}
	   	}
	   	else
	   	{
	   		return false;
	   	}

   }
   
   public function calcula_total_venc($valor,$id_venc)
   {
   	
   	$venc = new core_Model_DbTable_Vencimento();
   	$venc = $venc->find($id_venc);
   	
   	if (count($venc) > 0)
   	{
   		if ($venc[0]['DESCONTO_PRECO'] != '')
   		{
   			$desconto 	=  $valor * ($venc[0]['DESCONTO_PRECO']/100);
   			$valor 		= $valor - $desconto;
   		}	
   		elseif ($venc[0]['AUMENTO_PRECO'] != '')
   		{
   			$desconto 	=  $valor * ($venc[0]['AUMENTO_PRECO']/100);
   			$valor 		= $valor + $desconto;
   		}
   	}	
   	
   	return $valor;
   	
   }
   
   public function geraDuplicata($id)
   {
   
   	$translate  	= Zend_Registry::get('Zend_Translate');
   	$modelDupli 	= new core_Model_DbTable_Duplicata();
   
   	$idNf 			= $id;
   	$nfRow 			= $this->decrypt(array_shift($this->findMultipleKey($idNf)));
   
   	if ($nfRow['FORMA_PAGTO'] != '2' && $nfRow['FORMA_PAGTO'] != '3')
   	{
   		return false;
   	}	
   	
   	
   	$modelemp 		= new core_Model_DbTable_Empresa();
   	$empRow 		= array_shift($modelemp->find($nfRow['EMPRESA'])->toArray());
   
   	$cliente = Zend_Registry::get('Cliente');
   
   	if($cliente[0]['IND_COM_SERV'] == "I")
   	{
   		$modelCli = new ind_Model_DbTable_Cliente();
   	}
   
   	else if($cliente[0]['IND_COM_SERV'] == "C")
   	{
   		$modelCli = new com_Model_DbTable_Cliente();
   	}
   
   	else
   	{
   		$modelCli = new serv_Model_DbTable_Cliente();
   	}
   
   	$cliRow 	= $modelCli->decrypt(array_shift($modelCli->find($nfRow["CLIENTE"])->toArray()));
   
   	$modelVenc 	= new core_Model_DbTable_Vencimento();
   	$vencRow 	= array_shift($modelVenc->find($nfRow["VENCIMENTO"])->toArray());
   
   	$data_base = date('Y-m-d');
   	$explode   = explode("-", $data_base);
   	$data_mk   = mktime(0,0,0,$explode['1'],$explode['2'],$explode['0']);
   
   	$datad 	= array();
   	$val 	= $nfRow['VALOR_TOTAL'];
   	$soma  	= 0;
   
   	for($i=1;$i<=$vencRow["NUMERO_VEZES"];$i++)
   	{
   
	   	if (is_null($vencRow['PROPORCAO'])) $vencRow['PROPORCAO'] = 1;
	   
	   		if($vencRow['PROPORCAO'] == 1)
	   		{
	   			if($vencRow["NUMERO_VEZES"] != $i)
	   			{
	   				$val_parcela = ($val / $vencRow["NUMERO_VEZES"]);
	   				//       			$val_parcela = number_format($val_parcela, 2);
	   				$soma        += $val_parcela;
	   
	   			}else
	   			{
	   				$val_parcela = $val - $soma;
	   			}
	   		}
	   
	   	if($vencRow['PROPORCAO'] == 2)
	   	{
   			$imposto            = @$nfRow['TOTAL_PIS'];
   			if (is_null($imposto) || !isset($imposto)) $imposto = 0;
   			$total_sem_imposto  = $val - $imposto;
   
   			$val_parcela        = $val / $vencRow["NUMERO_VEZES"];
   			//       		$val_parcela        = number_format($val_parcela, 2);
   
   			if($vencRow["NUMERO_VEZES"] != $i)
	   		{
		   		if($i == 1)
		   		{
		   			$val_parcela += $imposto;
		   		}
		   
		   		$soma += $val_parcela;
		   
		   		}
		   		else
		   		{
		   			$val_parcela = $val - $soma;
		   		}
	   		}
	   
	   
	   		if($vencRow['PROPORCAO'] == 3)
	   		{
		   		if($vencRow["NUMERO_VEZES"] != $i)
		   		{
			   		$val_parcela = ( ($val * $vencRow['PROPORCAO_'.$i]) / 100);
			   		$soma        += $val_parcela;
		   
		   		}
		   		else
		   		{
		   			$val_parcela = $val - $soma;
		   		}
	   	}
	   	
	   	$val_parcela = number_format($val_parcela, 2,".","");
	   
   		$data_mk   = mktime(0,0,0,$explode['1'],$explode['2'] + $vencRow['C'.$i],$explode['0']);
   		$data_venc = date("Y-m-d", $data_mk);
   
   		$datad[$i]['REGISTROGQ'] 			= 0;
   		$datad[$i]['NF'] 					= NULL;
   		$datad[$i]['EMPRESA1'] 				= $nfRow['EMPRESA'];
   		$datad[$i]['RECEITA'] 		  		= null;
   		$datad[$i]['NUMERO_DA_PARCELA'] 	= $i;
   		
   		/* cuidado ao alterar a descricao pois ela serve de pesquisa para 
   		 * as demais operacoes com esta a duplicata 
   		 * verificar funcao getDupliVenda no DB orcamentoCliente
   		 * verificar funcao rollbackDupliVenda no DB orcamentoCliente
   		 */
   		$datad[$i]['DESCRICAO'] 		 	= "Pedido de Venda Numero: ".$nfRow['CLIENTE'].'/'.$nfRow['ITEM'];   
   		
   		$datad[$i]['DATA_EMISSAO'] 	 	 	= $data_base;
   		$datad[$i]['CODIGO_CLIENTE']	 	= $nfRow['CLIENTE'];
   		$datad[$i]['VENCIMENTO'] 		 	= $data_venc;
   		$datad[$i]['NOVO_VENCIMENTO']   	= $data_venc;
   		$datad[$i]['VALOR'] 	 			= $val_parcela;
   		$datad[$i]['FORMA_ENVIO']		 	= null;
   		$datad[$i]['BANCO'] 			 	= $empRow['BANCO_DEFAULT'];
   		$datad[$i]['APROVACAO'] 		 	= null;
   
   		$modelDupli->insert($datad[$i]);
	   		
	}
   
   	}
}
?>